IF OBJECT_ID('F_INADIMPLENCIA_SINTETICO') IS NOT NULL
BEGIN
	DROP FUNCTION F_INADIMPLENCIA_SINTETICO
END
GO

CREATE FUNCTION F_INADIMPLENCIA_SINTETICO(@DT_BASE DATETIME,@DT_INI DATETIME,@DT_FIN DATETIME)
RETURNS TABLE AS
RETURN
SELECT 
	GRUPO_ECONOMICO,
	BANDEIRA,
	CIDADE,
	UF,
	YEAR(DT_VENCTO) AS ANO,
	MONTH(DT_VENCTO) AS MES,
	CD_REG,
	DS_REG,
	IS_CLIENTE_CONVENIO,
	IS_CLIENTE_CREDIARIO,
	IS_CLIENTE_OUTROS,
	SUM(VLR_FATURAS)		AS VLR_FATURAS,
	SUM(VLR_AMORTIZADO)		AS VLR_AMORTIZADO,
	SUM(VLR_DESCONTOS)		AS VLR_DESCONTOS,
	SUM(VLR_JUROS)			AS VLR_JUROS,
	(SUM(VLR_FATURAS) - SUM(VLR_AMORTIZADO)) AS VLR_SALDO_PENDENTE,
	((SUM(VLR_FATURAS) - SUM(VLR_AMORTIZADO)) * 100) / SUM(VLR_FATURAS) AS PERC_INADIMPLENCIA
FROM	F_INADIMPLENCIA_ANALITICO(@DT_BASE,@DT_INI,@DT_FIN)

GROUP BY
	GRUPO_ECONOMICO,
	BANDEIRA,
	CIDADE,
	UF,
	YEAR(DT_VENCTO),
	MONTH(DT_VENCTO),
	CD_REG,
	DS_REG,
	IS_CLIENTE_CONVENIO,
	IS_CLIENTE_CREDIARIO,
	IS_CLIENTE_OUTROS

GO


--SELECT * FROM F_INADIMPLENCIA_SINTETICO(GETDATE(),'2014-01-01',GETDATE()-1)